package gov.va.med.mhv.mrp.web.converter;

import java.io.Serializable;
import java.util.Collections;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.web.model.MyGoalTask;
import gov.va.med.mhv.mrp.web.model.MyGoalsExtension;
import gov.va.med.mhv.mrp.web.util.MyGoalTaskCompare;

@Component
public class MyGoalExtensionsConverter implements Converter<MyGoalsExtensionDTO, MyGoalsExtension>, Serializable {
	private static final long serialVersionUID = 1L;
	
	@Autowired
	private MyGoalTaskConverter myGoalTaskConverter;

	@Override
	public MyGoalsExtension convert(MyGoalsExtensionDTO dto) {
		MyGoalsExtension model = new MyGoalsExtension();

		model.setDescription(dto.getDescription());
		model.setGoalExtensionId(dto.getGoalExtensionId());
		model.setGoalExtensionSeqNo(dto.getGoalExtensionSequenceNumber());
		model.setGoalExtensionType(dto.getGoalExtensionType());
		model.setOplock(dto.getOplock());
		
		if (dto.getMyGoalsTasks() != null) {
			for (MyGoalTaskDTO myGoalTaskDTO : dto.getMyGoalsTasks()) {
				MyGoalTask myGoalTask = myGoalTaskConverter.convert(myGoalTaskDTO);
				model.getTasks().add(myGoalTask);
			}
			
			Collections.sort(model.getTasks(), new MyGoalTaskCompare());
		}

		return model;
	}

}
